/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.json;

import com.aptana.json.ISchemaContext;
import com.aptana.json.IState;
import com.aptana.json.Messages;
import com.aptana.json.Schema;
import com.aptana.json.SchemaEventType;

public class SchemaArray
implements IState {
    private Schema _owningSchema;
    private String _elementTypeName;
    private ArrayState _currentState;

    public SchemaArray(Schema owningSchema, String elementTypeName) {
        this._owningSchema = owningSchema;
        this._elementTypeName = elementTypeName;
    }

    public void enter() {
        this._currentState = ArrayState.READY;
    }

    public void exit() {
    }

    public IState getElementType() {
        return this._owningSchema.getType(this._elementTypeName);
    }

    public String getElementTypeName() {
        return this._elementTypeName;
    }

    public Schema getOwningSchema() {
        return this._owningSchema;
    }

    public boolean isValidTransition(SchemaEventType event, Object value) {
        boolean result = false;
        switch (event) {
            case START_ARRAY: {
                result = this._currentState == ArrayState.READY;
                break;
            }
            case END_ARRAY: {
                result = this._currentState == ArrayState.IN_ARRAY;
            }
        }
        return result;
    }

    public void transition(ISchemaContext context, SchemaEventType event, Object value) {
        switch (event) {
            case START_ARRAY: {
                if (this._currentState != ArrayState.READY) {
                    throw new IllegalStateException(Messages.SchemaArray_Cannot_Start_Started_Array);
                }
                this._currentState = ArrayState.IN_ARRAY;
                break;
            }
            case START_ARRAY_ENTRY: {
                if (this._currentState != ArrayState.IN_ARRAY) {
                    throw new IllegalStateException(Messages.SchemaArray_Cannot_Start_Started_Array_Element);
                }
                this._currentState = ArrayState.IN_ELEMENT;
                context.pushType(this.getElementTypeName(), this.getElementType());
                context.createType(this.getElementTypeName(), this.getElementType(), value);
                break;
            }
            case END_ARRAY: {
                if (this._currentState != ArrayState.IN_ARRAY) {
                    throw new IllegalStateException(Messages.SchemaArray_Cannot_End_Unstarted_Array);
                }
                this._currentState = ArrayState.COMPLETE;
                context.popType();
                break;
            }
            case END_ARRAY_ENTRY: {
                if (this._currentState != ArrayState.IN_ELEMENT) {
                    throw new IllegalStateException(Messages.SchemaArray_Cannot_End_Unstarted_Array_Element);
                }
                this._currentState = ArrayState.IN_ARRAY;
                context.addElement(this.getElementTypeName(), this.getElementType());
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(Messages.SchemaArray_Unsupported_Event) + event.name());
            }
        }
    }

    public String toString() {
        return "Array<" + this._elementTypeName + ">";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ArrayState {
        READY,
        IN_ARRAY,
        IN_ELEMENT,
        COMPLETE;

    }
}

